***********************************************************************
*******************DEBT AND CONSUMPTION - SET UP***********************
*************************DATE: MAY 2019 *******************************
************************ AUTHOR: FIONA PRICE **************************
***********************************************************************

clear all
set more off
set maxvar 30000

//Load data
use "C:\UnbalancedHH.dta", replace

*** Drop persons without household  population weight information
drop if hhwth<0|hhwth==.

**********************
***** Set panel ******
**********************
replace hhid0= subinstr(hhid0, "a", "2001",.) 
replace hhid0= subinstr(hhid0, "b", "2002",.) 
replace hhid0= subinstr(hhid0, "c", "2003",.) 
replace hhid0= subinstr(hhid0, "d", "2004",.) 
replace hhid0= subinstr(hhid0, "e", "2005",.) 
replace hhid0= subinstr(hhid0, "f", "2006",.) 
replace hhid0= subinstr(hhid0, "g", "2007",.) 
replace hhid0= subinstr(hhid0, "h", "2008",.) 
replace hhid0= subinstr(hhid0, "i", "2009",.) 
replace hhid0= subinstr(hhid0, "j", "2010",.) 
replace hhid0= subinstr(hhid0, "k", "2011",.) 
replace hhid0= subinstr(hhid0, "l", "2012",.) 
replace hhid0= subinstr(hhid0, "m", "2013",.) 
replace hhid0= subinstr(hhid0, "n", "2014",.) 
replace hhid0= subinstr(hhid0, "o", "2015",.) 
replace hhid0= subinstr(hhid0, "p", "2016",.) 
replace hhid0= subinstr(hhid0, "q", "2017",.) 

destring hhid0, replace
xtset hhid0 wave
**********************************************************************
**********************************************************************
******************** 1. SET UP KEY VARIABLES *************************
**********************************************************************
**********************************************************************

//CPI data (2017/18=100; see ABS website, Cat No 6401.0)
g cpi = 66.53306613 if wave== 1
replace cpi = 68.67067468 if wave==2
replace cpi = 70.45201514 if wave==3
replace cpi = 72.05522155 if wave==4
replace cpi = 74.28189713 if wave==5
replace cpi = 77.22110888 if wave==6
replace cpi = 78.64618125 if wave==7
replace cpi = 82.56513026 if wave==8
replace cpi = 83.54486751 if wave==9
replace cpi = 85.94967713 if wave==10
replace cpi = 88.88888889 if wave==11
replace cpi = 90.67022935 if wave==12
replace cpi = 92.62970385 if wave==13
replace cpi = 94.7673124 if wave==14
replace cpi = 96.19238477 if wave==15
replace cpi = 97.43932309 if wave==16
replace cpi = 99.22066355 if wave==17

//time periods
gen crisis = 0
replace crisis=1 if year==2009 //GFC

gen wealthyear = 1 if wave==2
replace wealthyear = 2 if wave==6
replace wealthyear = 3 if wave==10
replace wealthyear = 4 if wave==14


**********************************************************************************************************************************************************************************************
*** Household characteristics ***

//State
	g nsw=0
	replace nsw=1 if hhstate==1
	g vic=0
	replace vic=1 if hhstate==2
	g qld=0
	replace qld=1 if hhstate==3
	g sa=0
	replace sa=1 if hhstate==4
	g wa=0
	replace wa=1 if hhstate==5
	g other=0
	replace other=1 if hhstate>=6

//Age variables
	g age = hgage
	g age2 = age^2
	g agewmax = 1 if hgagemax<30 //age categories based on oldest hh member
	replace agewmax = 2 if hgagemax>=30 & hgagemax<50
	replace agewmax = 3 if hgagemax>=50
	tabulate agewmax, generate(agevar)

//HH members
	g kids = tcr04 + tcr514 if tcr04>=0 & tcr514>=0
	g adults = hhadult

//Education
	g educ = 1 if edhigh1>=8 & edhigh1!=. //high school
	replace educ = 2 if edhigh1==5|edhigh1==4 & edhigh1!=. //TAFE
	replace educ = 3 if edhigh1<=3 & edhigh1>=0 & edhigh1!=. //University
	tabulate educ, generate(educvar)

//Gender and martial status
	g sex = 0 if hgsex>0 & hgsex!=.
	replace sex = 1 if hgsex==1
	g married = 0 if mrcurr>0 & mrcurr!=.
	replace married = 1 if mrcurr==1|mrcurr==2

//Labour force status
	g nilf = 0 if esbrd>0 & esbrd!=. //not in labour force
	replace nilf = 1 if esbrd==3
	g emp = 0 if esbrd>0 & esbrd!=. //employed
	replace emp = 1 if esbrd==1
	g unemp = 0 if esbrd>0 & esbrd!=. //unemployed
	replace unemp = 1 if esbrd==2
	g becunemp = 0 if unemp!=. & L.unemp!=.
	replace becunemp = 1 if unemp==1 & L.unemp==0 //become unemployed

//Job security
	g losejob=0 if jbmplojmax!=. & jbmplojmax!=-1
	replace losejob=1 if jbmplojmax>0 & jbmplojmax!=. & jbmplojmax!=-1 //probability losing job more than 0%
	g casual = 0 if jbmcnt!=. & jbmcnt!=-1 & emp==1
	replace casual = 1 if jbmcnt==2|jbcasab==1 //causal workers

//Region unemployment rate
	g asgs4 = hhssa4
	replace asgs4=. if asgs4<0
	merge m:1 year asgs4 using "C:\localunemployment.dta" , nogen keep(match master)
	sort hhid0 wave
	g regenionshock = lfunemp-L.lfunemp //change in regional unemployment rate
	g shockdum = 0 if regenionshock!=. //regional unemployment shock
	replace shockdum=1 if regenionshock>1 & regenionshock!=.

//Home ownership
	g own = 0 if (hstenr!=. & wave>=2)|(hstenur!=. & wave==1) 
	replace own =1 if hstenr==1|hstenur==1 //own home with or without mortgage

//Financial stress
	g lcons = 0
	replace lcons = 1 if fiprbegmin==1|fiprbfhmin==1|fiprbmrmin==1|fiprbpsmin==1|fiprbuhmin==1|fiprbwmmin==1|fiprbwomin==1
	replace lcons = . if fiprbegmin==.|fiprbfhmin==.|fiprbmrmin==.|fiprbpsmin==.|fiprbuhmin==.|fiprbwmmin==.|fiprbwomin==.

//Mortgage characteristics
	g expect = 0 if own==1 & hsmgfin>=0 & hsmgfin!=. //when expect loan paid off
	replace expect = hsmgfin- wave-2000 if hsmgfin>=0 & hsmgfin!=. 

	g mortpay = hsmgi if hsmgi>0 & hsmgi!=. //o-o mortgage repayments
	replace mortpay=0 if mortpay==.
	replace mortpay=mortpay/cpi*100
	
	gen behindnew1=0 if hsmgsch!=. & hsmgsch>0 //behind on mortgage repayments
	replace behindnew1=1 if hsmgsch==2|hsmgsch==3
	replace behindnew1=0 if hsmgsch==-1 & own==1

	gen ownout = 0 if hstenr==1 //own home outright
	replace ownout=1 if own==1 & (hsmgpd==1|hsmgpd==-1)
	
	g yearpaidoff = 0 if L.hsmgpd>0 & L.hsmgpd!=. //paid off mortgage
	replace yearpaidoff = 1 if hsmgpd==1 & L.hsmgpd==2
	gen paidoffdur = 0 if yearpaidoff==1
	replace paidoffdur = -1 if F.yearpaidoff==1
	replace paidoffdur = -2 if F2.yearpaidoff==1
	replace paidoffdur = -3 if F3.yearpaidoff==1
	replace paidoffdur = 1 if L.yearpaidoff==1
	replace paidoffdur = 2 if L2.yearpaidoff==1
	replace paidoffdur = 3 if L3.yearpaidoff==1
	
//o-o housing debt
	g hdebt = hsmgowe if hsmgowe>0 & hsslowe<0 //first mortgage
	replace hdebt=hsslowe if hsmgowe<=0 & hsslowe>0 //second mortgage
	replace hdebt = hsmgowe+hsslowe if hsmgowe>0 & hsslowe>0 //first and second mortgages
	replace hdebt = 0 if own==1 & hsmgpd==1 &  hsslowe<0 //reported that have paid off home and do not have second mortgage
	replace hdebt=. if hstenr!=1 & wave>1 //missing if do not own home with or without mortgage
	replace hdebt=. if hstenur!=1 & wave==1 //missing if do not own home with or without mortgage
	replace hdebt=0 if hsmgpd==1 & hdebt==.
	replace hdebt=. if hsmgowe==-3

	gen rhdebt=hdebt/cpi*100
	
//Mortgage buffer based on scheduled loan
	merge 1:1 xwaveid year using "C:\Fiona\required_new.dta" ,nogen keep(match master)
	g buffer = schedule - (hdebt*cpi/100) if schedule!=. & hdebt!=.
	replace buffer=buffer/cpi*100
	replace buffer = 0 if buffer < 0
	replace buffer = 0 if buffer==.

**********************************************************************************************************************************************************************************************
***** Income ******

//Disposable income
	g hincome = hifdip - hifdin 
	drop inc
	g inc = hincome
//Imputed rent
	gen imputedrent=hsvalue*0.05 - mortpay if hsvalue>0 & hsvalue!=.
	replace imputedrent = hsrnti*12 if hsrnti>0 & hsrnti!=. & imputedrent==.
	replace imputedrent=0 if imputedrent==.
//Disposable income adj for imputed rent
	gen incadj = inc+imputedrent if hsrnti==-1 
	replace incadj=inc if incadj==.
//Quartiles of income
	g xinc = 0 
	foreach x of numlist 1/17{
	xtile xinc`x' = inc if wave==`x' [weight = hhwth], nq(5) 
	replace xinc=1 if xinc`x'==1
	replace xinc=2 if xinc`x'==2
	replace xinc=3 if xinc`x'==3
	replace xinc=4 if xinc`x'==4
	replace xinc=5 if xinc`x'==5
	}

**********************************************************************************************************************************************************************************************
*** Consumption ***

	foreach x in hxycomp hxyfurn hxyhol hxyncar hxytvav hxyucar hxyhltp hxyoi hxyphrm hxyteli hxywcf hxyccf hxymcf hxyalc hxycig hxyeduc hxygroc hxyhmrn hxymeal hxymvf hxymvr hxypbti hxyphi hxypubt hxyutil hxywg{
	replace `x'=0 if `x'<0
	}

//total, durable and non-durable consumption
	g exp = (hxycomp+hxyfurn+hxyhol+hxyncar+hxytvav+hxyucar+hxyhltp+hxyoi+hxyphrm+hxyteli+hxywcf+hxyccf+hxymcf+hxyalc+hxycig+hxyeduc+hxygroc+hxyhmrn+hxymeal+hxymvf+hxymvr+hxypbti+hxyphi+hxyutil+hxypubt+hxywg)
	g nondurexp = (hxyhltp+hxyoi+hxyphrm+hxyteli+hxywcf+hxyccf+hxymcf+hxyalc+hxycig+hxyeduc+hxygroc+hxyhmrn+hxymeal+hxymvf+hxymvr+hxypbti+hxyphi+hxyutil+hxypubt)
	g durable = exp - nondurexp if wave>=6 & wave<=10
	g consump = durable + nondurexp if wave<=10 & wave>=6 & durable>=0 & nondurexp>0 & durable!=. & nondurexp!=.
	g consumpadj = consump+imputedrent
	gen rdurable = durable/cpi*100
	g rinc = inc/cpi*100
	g rexp = nondurexp/cpi*100
	g rconsump = consump/cpi*100
**********************************************************************************************************************************************************************************************
***** Wealth ******

//o-o housing assets and equity
	g hp1 = hsvalue if hsvalue>0 //o-o housing assets
	g hequity = hp1 - hdebt if hp1>0 //o-o housing equity
	replace hequity = 0 if (hstenr>1 & hstenr!=.)|(hstenur>1 & hstenur!=.)

//postcode housing prices
	destring hhpcode, replace
	g postcode = hhpcode
	replace postcode=. if postcode<0
	sort hhid0 wave
	merge m:1 postcode wave using "C:\hprices_by_postcode_year.dta", nogen keep(match master)
	sort hhid0 wave
	gen neghprice = 0 if postgrowthhp!=.
	replace neghprice=1 if postgrowthhp<-5 & postgrowthhp!=.

//o-o debt ratios
	g debtasset = (hdebt/hp1)*100 //leverage ratio
	replace debtasset = 0 if hp1==0
	g hdebtinc = (hdebt/inc)*100 //debt-to-income ratio
	replace hdebtinc = 0 if inc==0
	g mortinc = (mortpay*12)/inc*100 //debt servicing ratio
	replace mortinc = 0 if inc==0
	
	sort hhid0 wave
	g highlvr = 0 if L.debtasset!=. //high LVR
	replace highlvr = 1 if L.debtasset>80 & L.debtasset!=.

//Quartiles of o-o debt
	g xdebt=0 // quartiles of debt
	foreach x of numlist 1/17{
	xtile xdebt`x' = hdebt if wave==`x' & hdebt>0 [weight = hhwth], nq(4) 
	replace xdebt=1 if xdebt`x'==1
	replace xdebt=2 if xdebt`x'==2
	replace xdebt=3 if xdebt`x'==3
	replace xdebt=4 if xdebt`x'==4
	replace xdebt=5 if xdebt`x'==5
	}

	g highly = 0 
	replace highly = 1 if xdebt==4 & (wave==7)
	by hhid0: egen maxhighly = max(highly) //those that were highly indebted in 2007
	g haddebt = 0 
	replace haddebt = 1 if hdebt>0 &  hdebt!=. & (wave==7)
	by hhid0: egen maxhaddebt = max(haddebt) //those that were indebted in 2007

//Total assets and debt
	g debt = hwdebti //all debt
	g assets = hwassei //all assets
	g invdebt = hwopdti if hwopdti!=. //other property debt
	g nworth = assets - debt //total net wealth
	replace nworth=L.nworth if wave!=2 & wave!=6 & wave!=10 & wave!=14 & nworth==.
	replace nworth=F.nworth if wave!=2 & wave!=6 & wave!=10 & wave!=14 & nworth==.
	replace nworth=L2.nworth if wave!=2 & wave!=6 & wave!=10 & wave!=14 & nworth==.
	replace nworth=F2.nworth if wave!=2 & wave!=6 & wave!=10 & wave!=14 & nworth==.

//Hand-to-mouth households
	g liqassets = hwtbani + hweqini + hwcaini //liquid assets
	replace liqassets=L.liqassets if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqassets==.
	replace liqassets=F.liqassets if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqassets==.
	replace liqassets=L2.liqassets if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqassets==.
	replace liqassets=F2.liqassets if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqassets==.

	g liqdebt = hwccdti //liquid debt
	replace liqdebt=L.liqdebt if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqdebt==.
	replace liqdebt=F.liqdebt if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqdebt==.
	replace liqdebt=L2.liqdebt if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqdebt==.
	replace liqdebt=F2.liqdebt if wave!=2 & wave!=6 & wave!=10 & wave!=14 & liqdebt==.

	g liqnworth = liqassets-liqdebt //liquid net wealth
	g liqnw_adj = liqnworth + buffer 

	g illiqnworth = nworth-liqnworth //illiquid net wealth
	g illiqnw_adj = illiqnworth-buffer 

	g credit_limit = inc/12 //credit limit set to monthly pay (see KWV 2014)
	g pay = inc/26 //fornightly pay
	
//HTM hhs according to KVW (2014)
	g htm = 0 if pay/2<liqnworth & liqnworth>=0
	replace htm=1 if ((pay/2-credit_limit)>=liqnworth & liqnworth<=0)
	replace htm=0 if ((pay/2-credit_limit)<liqnworth & liqnworth<=0)
	replace htm=1 if (pay/2>=liqnworth & liqnworth>=0)

//HTM hhs according to KVW (2014) adjusted for prepayment buffers
	g htm_adj = 0 if pay/2<liqnw_adj & liqnw_adj>=0
	replace htm_adj=1 if ((pay/2-credit_limit)>=liqnw_adj & liqnw_adj<=0)
	replace htm_adj=0 if ((pay/2-credit_limit)<liqnw_adj & liqnw_adj<=0)
	replace htm_adj=1 if (pay/2>=liqnw_adj & liqnw_adj>=0)
		
**********************************************************************************************************************************************************************************************
*** Transforming variables ***

//Inverse hyperbolic sine
g consumpt = ln(consump+((consump^2)+1)^(1/2))
g consumpadjt = ln(consumpadj+((consumpadj^2)+1)^(1/2))
g expt = ln(nondurexp+((nondurexp^2)+1)^(1/2))
g durablet = ln(durable+((durable^2)+1)^(1/2))
g hdebtt = ln(hdebt+((hdebt^2)+1)^(1/2))
g hp1t = ln(hp1+((hp1^2)+1)^(1/2))
g hequityt = ln(hequity+((hequity^2)+1)^(1/2))
g inct = ln(inc+((inc^2)+1)^(1/2))
g incadjt = ln(incadj+((incadj^2)+1)^(1/2))
g wealthtt = ln(nworth+((nworth^2)+1)^(1/2))
g invdebtt = ln(invdebt+((invdebt^2)+1)^(1/2))
g mortpayt = ln(mortpay+((mortpay^2)+1)^(1/2))
g imputedrentt = ln(imputedrent+((imputedrent^2)+1)^(1/2))

//Lagged variables
sort hhid0 wave
g Linct = L.inct if L.inct!=.
g Lhequityt = L.hequityt if L.hequityt!=.
g Lhdebtt = L.hdebtt
gen Lhp1t = L.hp1t
gen Lmortpayt = L.mortpayt

//Growth variables
gen dinct = inct - L.inct if inct>0 & L.inct>0 //income growth 
replace dinct=dinct*100
gen dhp1t = hp1t - L.hp1t if hp1t>0 & L.hp1t>0 //housing price growth (self-assessed)
replace dhp1t=dhp1t*100
gen dconsumpt = consumpt - L.consumpt if consumpt>0 & L.consumpt>0 //total spending growth 
replace dconsumpt=dconsumpt*100
gen ddurablet = durablet - L.durablet if durablet>0 & L.durablet>0 //durable spending growth
replace ddurablet=ddurablet*100
gen dexpt = expt - L.expt if expt>0 & L.expt>0 //non-durable spending growth
replace dexpt=dexpt*100
gen dhequityt = hequityt - L.hequityt if hequityt>0 & L.hequityt>0 //home equity growth
replace dhequityt=dhequityt*100
gen dhdebtt = hdebtt - L.hdebtt if hdebtt>0 & L.hdebtt>0  //o-o debt growth
replace dhdebtt=dhdebtt*100
gen Ldhdebtt=L.dhdebtt


**********************************************************************************************************************************************************************************************
**** Year of Purchase ****

	g purchase = hsyr //only available every 4 years
	replace purchase=0 if hsyr==.|hsyr<0

//dealing with missing values
	forval x=1/17{
	replace purchase = L`x'.purchase if purchase==0 & L`x'.purchase>0 & L`x'.purchase!=. & year>L`x'.purchase
	}

	forval x=1/17{
	replace purchase = F`x'.purchase if purchase==0 & F`x'.purchase>0 & F`x'.purchase!=. & year>=F`x'.purchase
	}

	forval x=1/17{
	replace purchase = F`x'.purchase if purchase!=0 & year>=F`x'.purchase
	}
	replace purchase=0 if own!=1

	bysort hhid0: egen minpurchase=min(purchase) if purchase!=0
	sort hhid0 wave

**** Duration years before and after purchase for FHBs only ****
	g duration = year - purchase if purchase!=0 & hdebt!=.
	replace duration = 0 if F.duration!=. & (hdebt==.) & F.purchase==year & F.year!=. & F.hdebt!=.
	g duration2 = -1 if (hdebt==.|hdebt==0) & (F.purchase==F.year) & F.year!=. & F.hdebt!=.  & (purchase==.|purchase==0)
	replace duration2 = -2 if (hdebt==.|hdebt==0) & (F2.purchase==F2.year) & F2.year!=. & F2.hdebt!=. & (purchase==.|purchase==0)
	replace duration2 = -3 if (hdebt==.|hdebt==0) & (F3.purchase==F3.year) & F3.year!=. & F3.hdebt!=. & (purchase==.|purchase==0)
	replace duration = duration2 if duration2!=. & duration==.
	replace duration = . if purchase>minpurchase & minpurchase!=.
	replace duration = -1 if year<minpurchase &  F.duration==0
	replace duration = -2 if year<minpurchase &  F2.duration==0
	replace duration = -3 if year<minpurchase &  F3.duration==0

**********************************************************************************************************************************************************************************************
**** Year of Refinance ****

	gen refinance = hsrefy if hsrefy>0 & hsrefy!=. //only available every 4 years
	replace refinance=0 if hsrefy==.|hsrefy<0

//dealing with missing values
	forval x=1/17{
	replace refinance = L`x'.refinance if refinance==0 & L`x'.refinance>0 & L`x'.refinance!=. & year>=L`x'.refinance & L.refinance>=purchase & purchase!=0
	}
	forval x=1/17{
	replace refinance = F`x'.refinance if refinance==0 & F`x'.refinance>0 & F`x'.refinance!=. & year>=F`x'.refinance & F.refinance>=purchase & purchase!=0
	}

	forval x=1/17{
	replace refinance = F`x'.refinance if F`x'.refinance!=0 & F`x'.refinance<=year  & purchase!=0
	}

**********************************************************************************************************************************************************************************************
**** Debt in year of purchase ****

	g original = hsloana //only available every 4 years
	replace original=0 if hsloana==.|hsloana<0

//dealing with missing values
	forval x=1/17{
	replace original = L`x'.original if original==0 & L`x'.original>0 & L`x'.original!=. & year>=L`x'.purchase & purchase!=0
	}
	forval x=1/17{
	replace original = F`x'.original if original==0 & F`x'.original>0 & F`x'.original!=. & year>=F`x'.purchase & purchase!=0
	}

	forval x=1/17{
	replace original = F`x'.original if original!=0 & year>=F`x'.purchase & purchase!=0 & purchase==F`x'.purchase
	}

**********************************************************************************************************************************************************************************************
**** Housing price in year of purchase ****

	g price = hsprice //only available every 4 years
	replace price=0 if hsprice==.|hsprice<0

//dealing with missing values
	forval x=1/17{
	replace price = L`x'.price if price==0 & L`x'.price>0 & L`x'.price!=. & year>=L`x'.purchase & purchase!=0
	}
	forval x=1/17{
	replace price = F`x'.price if price==0 & F`x'.price>0 & F`x'.price!=. & year>=F`x'.purchase & purchase!=0
	}

	forval x=1/17{
	replace price = F`x'.price if price!=0 & year>=F`x'.purchase & purchase!=0 & purchase==F`x'.purchase
	}

**********************************************************************************************************************************************************************************************
**** Loan characteristics ****

	g loanstart = purchase if purchase!=0 & purchase!=. //year of purchasing or refinancing
	replace loanstart = refinance if refinance!=0 & refinance!=. 

	g yearsince = year-loanstart if purchase>0 //age of current loan
	replace yearsince = 0 if hstenr>1 & hstenr!=.|hstenur>1 & hstenur!=.
	replace yearsince = . if yearsince<0
	
	g length =  hsmgfin - loanstart if hsmgfin!=. & hsmgfin>=0 & purchase!=. & purchase>0 //length of loan

	gen hsmgfin2=hsmgfin if hsmgfin>0 & hsmgfin!=. & hdebt>0 & hdebt!=. //Year expected to have loan paid off 
	replace hsmgfin2=(L.hsmgfin2+F.hsmgfin2)/2 if hsmgfin2==. & hdebt>0 & hdebt!=. & loanstart==L.loanstart & loanstart==F.loanstart //missing values
	replace hsmgfin2=L.hsmgfin2 if hsmgfin2==. & hdebt>0 & hdebt!=. & loanstart==L.loanstart //missing values
	replace hsmgfin2=F.hsmgfin2 if hsmgfin2==. & hdebt>0 & hdebt!=. & loanstart==F.loanstart //missing values

	gen yearstopay = hsmgfin2-year if hsmgfin2!=. & hsmgfin2>0 //how many years between now and when expect loan to be paid off

	g ahead = loanstart+30-hsmgfin2 if hsmgfin2!=. & hsmgfin2>0 & loanstart>0 & loanstart!=. //standard loan term less expected loan term
	replace ahead=0 if ahead==.
	
**********************************************************************
**********************************************************************
************************* 3. INSTRUMENTS *****************************
**********************************************************************
**********************************************************************

//1. INSTRUMENT: PURCHASED BEFORE 2000s BOOM
g postboom = 0 if purchase>1900 & purchase!=.
replace postboom = 1 if purchase>2001 & purchase>1900 & (nsw==1|vic==1|qld==1) & purchase!=.
replace postboom = 1 if purchase>2002 & purchase>1900 & (other==1|wa==1|sa==1) & purchase!=.
gen Lpostboom = L.postboom

//2. INSTRUMENT: LOAN AT TIME OF PURCHASE
g originalt = ln(original+((original^2)+1)^(1/2))
replace originalt = 0 if hdebt==0

//3. INSTRUMENT: LOAN-TO-INCOME and LOAN-TO-VALUE RATIOs AT TIME OF PURCHASE (only for those that purchased during survey period)
g lti = original/hincome*100 if purchase==year
g ltiorig = original/hincome*100
g lvr = original/price*100 if purchase==year
g lvrorig = original/price*100

g lvrorig80 = 0 if lvrorig!=.
replace lvrorig80=1 if lvrorig>80 & lvrorig!=.

**********************************************************************
**********************************************************************
********************* 3. SAMPLE RESTRICTIONS *************************
**********************************************************************
**********************************************************************
// Trim distribution of total consumption growth
	bysort year: egen p1 = pctile(dconsumpt), p(1)
	bysort year: egen p99 = pctile(dconsumpt), p(99)
	g touse = inrange(dconsumpt, p1, p99) if dconsumpt!=. 
	sort hhid0 wave

// Trim distribution of non-durable consumption growth
	bysort year: egen p1nd = pctile(dexpt), p(1)
	bysort year: egen p99nd = pctile(dexpt), p(99)
	g tousend = inrange(dexpt, p1nd, p99nd) if dexpt!=. 
	sort hhid0 wave

// Trim distribution of income growth
	bysort year: egen p1i = pctile(dinct), p(1)
	bysort year: egen p99i = pctile(dinct), p(99)
	g touse2 = inrange(dinct, p1i, p99i) if dinct!=.
	sort hhid0 wave

// Trim distribution of housing price growth
	bysort year: egen p1hp = pctile(dhp1t), p(1)
	bysort year: egen p99hp = pctile(dhp1t), p(99)
	g touse3 = inrange(dhp1t, p1hp, p99hp) if dhp1t!=.
	sort hhid0 wave

//save file for analytical work
save "C:\UnbalancedHH_analytical NEW.dta", replace
